% Road_creation_1D
%-------------------------------------------------------------------------
% Witten By Tomas Mauder, VUT v Brne, 2014.
%-------------------------------------------------------------------------
function [z] = Road_creation_2D(road,A_x, omega_x, phi_x , psi_x, graphs)

% Delka cesty (m)
L1_x = road.L1_x;
L2_x = road.L2_x;
L_x = L2_x - L1_x;

L1_y = road.L1_y;
L2_y = road.L2_y;
L_y = L2_y - L1_y;

% Pocet vln

M_x = road.M_x;

% Pocet vzorku na 1 m cesty
N_x = road.N_x;
N_y = road.N_y;
% Rozdeleni cesty na L * N intervalu
s_x = road.sx;
s_y = road.sy;

% Inicializace zvlneni vozovky
xx = zeros(1,N_x * L_x);
yy = zeros(1,N_y * L_y);
z = zeros(N_x * L_x,N_y * L_y);

% Vypocet zvlneni vozovky (eq. 2.17)
for i = 1 : N_x * L_x + 1
      for j = 1 : N_y * L_y + 1        
          
            z(i,j) =sum((A_x.* sin((omega_x.* s_x(i)) - psi_x(:,j)')));               
      end
      
% progress bar     
     drawnow                
     stopBar = progressbar(i/(N_x * L_x),4);
     if (stopBar); break; end
      
end


%-------------------------------------------------------------------------
if graphs == 1
% graficky vystup

figure
% x - vzdalenost [m], y - zvlneni [cm]

surf(s_x,s_y,z'.*100)
 title('Profil cesty');
 xlabel('Vzdalenost x [m]');
 ylabel('Vzdalenost y [m]');
 zlabel('Zvlneni povrchu vozovky [cm]');
 set(gcf,'Color','w');
% axis([0 100 -10 10])
%  shading interp
colormap bone
end